local conf = require("app.core.conf")
local L    = require("app.core.lession")
local Y    = require("app.core.page")

local conf_span_count = 
{
	en1 = 1,
	en2 = 1,
	en3 = 1,
	en4 = 5,
	
	py1 = 1,
	py2 = 5,
	py3 = 5,

	wb1 = 1,
	wb1_98 = 1,
	wb2 = 1,
	wb3 = 1,
	wb4 = 5,
	
	test1 = 5,
	test2 = 10,
	test3 = 5,
	
	pm1 = 5,
}

local conf_span_maxccp = 
{
	en1 = 11,
	en2 = 48,
	en3 = 48,
	en4 = 48,
	
	py1 = 48,
	py2 = 28,
	py3 = 28,

	wb1 = 28,
	wb1_98 = 28,
	wb2 = 28,
	wb3 = 28,
	wb4 = 28,
	
	test1 = 28,
	test2 = 28,
	test3 = 28,
	
	pm1 = 28,
}

-----------------------------------------------------------------------
local function new_course()
	
	local self = {}

	self.load = function (self, luid, lession_file)
		conf:load()
		lession_file = lession_file or conf.all.course[luid].less
		return Y.new_page(
			L.load(lession_file, luid, conf_span_maxccp[luid]), 
			conf_span_count[luid]
			)
	end

	self.save = function (self, less)
		if less ~= nil and less.luid ~= nil then
			conf:load()
			local less = conf.all.course[less.luid].less
			conf.all.course[luid].less = less.less_file
			conf:save()
		end
	end
	
	return self
end

-----------------------------------------------------------------------
return new_course()
